/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserMask
extends Task {
    private String m_umask;
    private String[] m_curnodelist;

    public TaskUserMask(String[] nodeList, String umask) {
        this.m_umask = umask;
        this.m_curnodelist = nodeList;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet umaskRsltSet = new ResultSet();
        globalExec.checkUserMask(this.m_curnodelist, this.m_umask, umaskRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1071", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = umaskRsltSet.getResultTable();
        Enumeration e = t.keys();
        String orclUser = VerificationUtil.getDefaultOracleUser();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            this.m_resultSet.addResult(node, result.getStatus());
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available umask=" + avl));
                ReportUtil.writeRecord(node, avl, this.m_umask, ReportUtil.PASSED);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(this.m_umask);
                this.m_resultSet.getResult(node).setActualValue(avl);
                continue;
            }
            if (result.getStatus() == 2) {
                Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.m_umask, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7612", true, (Object[])new String[]{orclUser, node}), s_msgBundle, "7612");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                continue;
            }
            if (result.getStatus() != 3) continue;
            avl = (String)result.getResultInfoSet().firstElement();
            Trace.out((String)("Result.VERIFICATION_FAILED:: retrieved umask=" + avl));
            ReportUtil.writeRecord(node, avl, this.m_umask, ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7611", true, (Object[])new String[]{orclUser, node, this.m_umask, avl}), s_msgBundle, "7611");
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(this.m_umask);
            this.m_resultSet.getResult(node).setActualValue(avl);
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1072", false));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1073", false));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4565", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4564", false, (Object[])new String[]{this.m_umask});
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1071", false);
    }
}

